/*	bitmap.c	1.9	83/05/13	*/

#include <stdio.h>
#include "cpmio.h"

/*
 * Bit map handling routines;
 * - build the disk allocation bit map
 * - allocate a new block
 * - dump the bitmap in hex to stdout (debugging)
 * - count the number of blocks in use
 * Note: the first block is number zero and the
 * 	 directory always occupies the first few blocks,
 * 	 depending on the disk format. For a standard
 * 	 SSSD disk the blocks are numbered 0 thru 243 and
 * 	 the directory occupies blocks 0 and 1.
 */

static
ffc(int start, int len, long field)
{
	register int i;

	for (i=start; i<len; i++) {
		if ((field&1) == 0)
			break;
		field >>= 1;
	}
	return (i);
}

/* 
 * Allocate a new disk block, return NULL if disk full 
 */
int
cpm_alloc(struct cpmfs *cpm)

{

	int i, j, blk;

	for (i=0; i<cpm->bm_size; i++) {
		j = ffc(0, INTSIZE, cpm->bitmap[i]);
		if ( j < INTSIZE) break;
	}

	if (i == cpm->bm_size) {	/* no free space was found	*/
	    return(0);
	}

	blk = i * INTSIZE + j;

	cpm->bitmap[i] |= (1 << j); /* set the appropriate bit in the bitmap */

#ifdef DEBUG
	printf("block number allocated: %d (0x%x)\n", blk, blk);
	dbmap("new bitmap:"); 
#endif

	return (blk);
}


/* 
 * Return the number of bloks used in the
 * directory, including the directory blocks
 */

cpm_blks_used(struct cpmfs *cpm)
{

    int j, i, temp;
    int buse = 0;

    for (i=0; i < cpm->bm_size; i++) {
	if (cpm->bitmap[i] == 0) 
	    continue;
	if (cpm->bitmap[i] == -1) {
	    buse += INTSIZE;
	} else  {
	    temp = cpm->bitmap[i];
	    for (j=0; j < INTSIZE; j++) {
		if (1 & temp) 
		    ++buse;
		temp >>= 1;
	    }
	}
    }
    return (buse);
}


/************************************************************************
 * NAME:	cpm_build_bmap()
 *
 * DESCR:	Build the block allocation bitmap.
 *
 * ARGS:	
 *
 * RETURNS:	TRUE if things went OK, FALSE otherwise
 *
 * NOTES:	
 ************************************************************************/
int
cpm_build_bmap(struct cpmfs *cpm)
{
	int	i, j, *malloc(), offset, block;

	cpm->bm_size = 1 + (((long)cpm->seclth*cpm->sectrk*(cpm->tracks-cpm->restrk))/cpm->blksiz)/INTSIZE;

	if (!cpm->bitmap) {
	    if ((cpm->bitmap = malloc(cpm->bm_size*4)) == NULL) {
		return(FALSE);	/* out of memory	*/
	    }
	}

	for (i=0; i<cpm->bm_size; i++)	/* clear bitmap just in case	*/
		cpm->bitmap[i] = 0;

	i = (cpm->maxdir*32)/cpm->blksiz; 	/* num of blocks used by dir	*/

	/* set the directory blocks busy in the bitmap */
	/* this is pretty tricky...the (-1) sets all bits LOWER than i	*/

	cpm->bitmap[0] = (1 << i) -1;  

	for (i=0; i<cpm->maxdir; i++) {

	    if (cpm->dirbuf[i].status != (char) 0xe5) {

		if(cpm->use16bitptrs) {
		    for (j=0; (j<8)&&
			     ((cpm->dirbuf[i].pointers[2*j] != '\0')
			      ||(cpm->dirbuf[i].pointers[2*j+1] != '\0'));
			 j++){
			block = (0xff & (int)cpm->dirbuf[i].pointers[2*j])
			    + (0xff00 & ((int)cpm->dirbuf[i].pointers[2*j+1]<<8));
			offset = block / INTSIZE;
			if(offset < 0 || offset > cpm->bm_size*4) {
			    return(FALSE);
			}
			cpm->bitmap[offset] |= (1 << block % INTSIZE);
		    }
		} else {
		    for (j=0; (j<16)&&(cpm->dirbuf[i].pointers[j] != '\0'); j++){
			block = 0xff & (int)cpm->dirbuf[i].pointers[j];
			offset = block / INTSIZE;
			if(offset < 0 || offset > cpm->bm_size*4) {
			    return(FALSE);
			}
			cpm->bitmap[offset] |= (1 << block % INTSIZE);
		    }
		}
	    }

	}

	return(TRUE);
}
